
; PicBasic Pro Compiler 2.46, (c) 1998, 2005 microEngineering Labs, Inc. All Rights Reserved.  
PM_USED			EQU	1

	INCLUDE	"16F877.INC"


; Define statements.
#define		CODE_SIZE		 8
#define		LCD_DREG		        PORTB
#define		LCD_DBIT		        0
#define		LCD_RSREG		       PORTB
#define		LCD_RSBIT		       4         
#define		LCD_EREG		        PORTB
#define		LCD_EBIT		        5         
#define		LCD_DATAUS		      100        
#define		LCD_COMMANDUS		   4000
#define		OSC		 20

RAM_START       		EQU	00020h
RAM_END         		EQU	001EFh
RAM_BANKS       		EQU	00004h
BANK0_START     		EQU	00020h
BANK0_END       		EQU	0007Fh
BANK1_START     		EQU	000A0h
BANK1_END       		EQU	000EFh
BANK2_START     		EQU	00110h
BANK2_END       		EQU	0016Fh
BANK3_START     		EQU	00190h
BANK3_END       		EQU	001EFh
EEPROM_START    		EQU	02100h
EEPROM_END      		EQU	021FFh

R0              		EQU	RAM_START + 000h
R1              		EQU	RAM_START + 002h
R2              		EQU	RAM_START + 004h
R3              		EQU	RAM_START + 006h
R4              		EQU	RAM_START + 008h
R5              		EQU	RAM_START + 00Ah
R6              		EQU	RAM_START + 00Ch
R7              		EQU	RAM_START + 00Eh
R8              		EQU	RAM_START + 010h
FLAGS           		EQU	RAM_START + 012h
GOP             		EQU	RAM_START + 013h
RM1             		EQU	RAM_START + 014h
RM2             		EQU	RAM_START + 015h
RR1             		EQU	RAM_START + 016h
RR2             		EQU	RAM_START + 017h
_Volt            		EQU	RAM_START + 018h
_Battvolt        		EQU	RAM_START + 01Ah
_V1              		EQU	RAM_START + 01Bh
_V2              		EQU	RAM_START + 01Ch
_V3              		EQU	RAM_START + 01Dh
_V4              		EQU	RAM_START + 01Eh
_PORTL           		EQU	 PORTB
_PORTH           		EQU	 PORTC
_TRISL           		EQU	 TRISB
_TRISH           		EQU	 TRISC

; Constants.
_T2400           		EQU	00000h
_T1200           		EQU	00001h
_T9600           		EQU	00002h
_T300            		EQU	00003h
_N2400           		EQU	00004h
_N1200           		EQU	00005h
_N9600           		EQU	00006h
_N300            		EQU	00007h
_OT2400          		EQU	00008h
_OT1200          		EQU	00009h
_OT9600          		EQU	0000Ah
_OT300           		EQU	0000Bh
_ON2400          		EQU	0000Ch
_ON1200          		EQU	0000Dh
_ON9600          		EQU	0000Eh
_ON300           		EQU	0000Fh
_MSBPRE          		EQU	00000h
_LSBPRE          		EQU	00001h
_MSBPOST         		EQU	00002h
_LSBPOST         		EQU	00003h
_LSBFIRST        		EQU	00000h
_MSBFIRST        		EQU	00001h
_CLS             		EQU	00000h
_HOME            		EQU	00001h
_BELL            		EQU	00007h
_BKSP            		EQU	00008h
_TAB             		EQU	00009h
_CR              		EQU	0000Dh
_UnitOn          		EQU	00012h
_UnitOff         		EQU	0001Ah
_UnitsOff        		EQU	0001Ch
_LightsOn        		EQU	00014h
_LightsOff       		EQU	00010h
_Dim             		EQU	0001Eh
_Bright          		EQU	00016h
	INCLUDE	"ANTRAK~1.MAC"
	INCLUDE	"PBPPIC14.LIB"

	MOVE?CB	00Eh, ADCON1
	MOVE?CB	001h, TRISA
	MOVE?CB	000h, PORTA
	MOVE?CB	000h, TRISB
	MOVE?CB	000h, PORTB
	MOVE?CB	000h, TRISC
	MOVE?CB	000h, PORTC
	MOVE?CB	000h, TRISD
	MOVE?CB	000h, PORTD
	MOVE?CB	000h, TRISE
	MOVE?CB	000h, PORTE
	CLEAR?	
	PAUSE?C	064h

	LABEL?L	_Main	
	LCDOUT?C	0FEh
	LCDOUT?C	001h
	LCDOUT?C	020h
	LCDOUT?C	041h
	LCDOUT?C	04Eh
	LCDOUT?C	054h
	LCDOUT?C	052h
	LCDOUT?C	041h
	LCDOUT?C	04Bh
	LCDOUT?C	020h
	LCDOUT?C	054h
	LCDOUT?C	041h
	LCDOUT?C	032h
	LCDOUT?C	043h
	LCDOUT?C	042h
	LCDOUT?C	041h
	LCDOUT?C	020h
	LCDOUT?C	020h
	LCDOUT?C	0FEh
	LCDOUT?C	0C0h
	LCDOUT?C	020h
	LCDOUT?C	04Ch
	LCDOUT?C	043h
	LCDOUT?C	044h
	LCDOUT?C	020h
	LCDOUT?C	056h
	LCDOUT?C	04Fh
	LCDOUT?C	04Ch
	LCDOUT?C	054h
	LCDOUT?C	04Dh
	LCDOUT?C	045h
	LCDOUT?C	054h
	LCDOUT?C	052h
	LCDOUT?C	045h
	LCDOUT?C	020h
	LCDOUT?C	020h
	PAUSE?C	007D0h

	LABEL?L	_Loop	
	GOSUB?L	_Batt
	CMPNE?BCL	_V4, 000h, L00001
	LCDOUT?C	0FEh
	LCDOUT?C	001h
	LCDOUT?C	042h
	LCDOUT?C	065h
	LCDOUT?C	073h
	LCDOUT?C	06Ch
	LCDOUT?C	065h
	LCDOUT?C	06Dh
	LCDOUT?C	065h
	LCDOUT?C	020h
	LCDOUT?C	056h
	LCDOUT?C	06Fh
	LCDOUT?C	06Ch
	LCDOUT?C	074h
	LCDOUT?C	061h
	LCDOUT?C	06Ah
	LCDOUT?C	069h
	LCDOUT?C	020h
	LCDOUT?C	0FEh
	LCDOUT?C	0C0h
	LCDOUT?C	020h
	LCDOUT?C	020h
	LCDOUT?C	020h
	LCDOUTD?B	_V3
	LCDOUT?C	02Eh
	LCDOUTD?B	_V2
	LCDOUTD?B	_V1
	LCDOUT?C	020h
	LCDOUT?C	056h
	LCDOUT?C	06Fh
	LCDOUT?C	06Ch
	LCDOUT?C	074h
	LABEL?L	L00001	
	CMPLE?BCL	_V4, 000h, L00003
	LCDOUT?C	0FEh
	LCDOUT?C	001h
	LCDOUT?C	042h
	LCDOUT?C	065h
	LCDOUT?C	073h
	LCDOUT?C	06Ch
	LCDOUT?C	065h
	LCDOUT?C	06Dh
	LCDOUT?C	065h
	LCDOUT?C	020h
	LCDOUT?C	056h
	LCDOUT?C	06Fh
	LCDOUT?C	06Ch
	LCDOUT?C	074h
	LCDOUT?C	061h
	LCDOUT?C	06Ah
	LCDOUT?C	069h
	LCDOUT?C	020h
	LCDOUT?C	0FEh
	LCDOUT?C	0C0h
	LCDOUT?C	020h
	LCDOUT?C	020h
	LCDOUTD?B	_V4
	LCDOUTD?B	_V3
	LCDOUT?C	02Eh
	LCDOUTD?B	_V2
	LCDOUTD?B	_V1
	LCDOUT?C	020h
	LCDOUT?C	056h
	LCDOUT?C	06Fh
	LCDOUT?C	06Ch
	LCDOUT?C	074h
	LABEL?L	L00003	
	PAUSE?C	064h
	GOTO?L	_Loop

	LABEL?L	_Batt	
	MOVE?CB	045h, ADCON0
	PAUSEUS?C	064h
	MOVE?BB	ADRESH, _Battvolt
	MUL?CBW	0C4h, _Battvolt, _Volt
	DIV?WCW	_Volt, 00Ah, _Volt
	MUL?WCW	_Volt, 003h, _Volt
	DIG?WCB	_Volt, 001h, _V1
	DIG?WCB	_Volt, 002h, _V2
	DIG?WCB	_Volt, 003h, _V3
	DIG?WCB	_Volt, 004h, _V4
	RETURN?	

	END
